IF NOT EXISTS (SELECT * FROM SYS.TABLES WHERE NAME = 'RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD')
BEGIN

CREATE TABLE [dbo].[RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD](
	[ID]					BIGINT IDENTITY(1, 1) NOT NULL,
	[ID_PROMOCAO]			BIGINT NOT NULL,
	[CD_EMP]				INT NOT NULL,
	[CD_PROD]				INT NOT NULL,
	[DS_PROD]				VARCHAR(200) NOT NULL,
	[ID_NIVEL]				INT NOT NULL,
	[PERC_DESC]				MONEY NOT NULL,
	[VLR_UNIT]				MONEY NOT NULL,
	CONSTRAINT PK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD PRIMARY KEY CLUSTERED ([ID])
) ON [PRIMARY]

END
GO

IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_EST_PROD')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_EST_PROD FOREIGN KEY (CD_EMP, CD_PROD) REFERENCES EST_PROD (CD_EMP, CD_PROD)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_EST_PROD
END
GO


IF NOT EXISTS (SELECT * FROM SYS.foreign_keys WHERE NAME = 'FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_RC_CLI_BEM_MAIS_PROMOCAO')
BEGIN
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD ADD CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_RC_CLI_BEM_MAIS_PROMOCAO FOREIGN KEY (ID_PROMOCAO) REFERENCES RC_CLI_BEM_MAIS_PROMOCAO (ID)
	ALTER TABLE RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD CHECK CONSTRAINT FK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_RC_CLI_BEM_MAIS_PROMOCAO
END
GO

IF NOT EXISTS (SELECT * FROM SYS.indexes WHERE NAME = 'UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_ID_PROMOCAO_CD_EMP_CD_PROD')
BEGIN
	CREATE UNIQUE INDEX UK_RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD_ID_PROMOCAO_CD_EMP_CD_PROD ON RC_CLI_BEM_MAIS_PROMOCAO_EST_PROD (ID_PROMOCAO, CD_EMP, CD_PROD)
END